ORCA/M Asm65816 2.1.0

0001 1516                              TITLE   '     Seek Routine'    
0002 1516              drivsubs proc 
0003 1516              **************************************************
0004 1516              *                                                *
0005 1516              *  seek                     Seek to a cylinder   *
0006 1516              *                     Assume cur_cyl is correct  *
0007 1516              *                                                *
0008 1516              *   Input:    cyl <- cylinder to seek to         *
0009 1516              *             drive <- drive on which to seek    *
0010 1516              *             cur_cyl <- head rests here         *
0011 1516              *   Output:   C <- set if seek error occurred    *
0012 1516              *             curnsect <- # sectors this cyl     *
0013 1516              *   Uses:     recal, sendsteps, WriteBit         *
0014 1516              *   Regs:     A <- error2 (if carry set)         *
0015 1516              *   Destroys: X, Y                               *
0016 1516              *                                                *
0017 1516              **************************************************
0018 1516                       export seek
0019 1516              SEEK      
0020 1516              *
0021 1516              * If drive is offline (cyl unknown), do a recal
0022 1516 AE 86 03              LDX   DRIVE
0023 1519 3C 52 03              BIT   cur_cyl,X                ;Set N to online
0024 151C 10 05                 BPL   @05                      ;If cyl known, skip recal
0025 151E 20 8E 15              JSR   RECAL
0026 1521 B0 53                 BCS   @SERR
0027 1523              @05      EQU   *
0028 1523              *
0029 1523              * Determine # of steps to take, and direction
0030 1523 38                    SEC   
0031 1524 AE 86 03              LDX   DRIVE
0032 1527 BD 52 03              LDA   cur_cyl,X
0033 152A ED 82 03              SBC   CYL                      ;Calculate delta 
0034 152D F0 3D                 BEQ   @80                      ;If on track, skip down
0035 152F              *
0036 152F              * At this point, C clear means inward seek, ow out
0037 152F A0 01                 LDY   #DIROUTADR               ;Assume outward seek 
0038 1531 B0 06                 BCS   @10                      ;Branch on outward seek
0039 1533              *
0040 1533 A0 00                 LDY   #DIRINADR                ;Setnasrt value for inward seek
0041 1535 49 FF                 EOR   #$FF                     ;Gotta convert the negative delta
0042 1537 69 01                 ADC   #1                       ;Carry was already clear 
0043 1539              *
0044 1539              @10      EQU   *
0045 1539 AA                    TAX                            ;move delta to X reg
0046 153A 98                    TYA                            ;Setup to set the direction
0047 153B 20 47 16              JSR   WRITEBIT
0048 153E              *
0049 153E              * Now do the stepping ; delta in X
0050 153E 20 7B 15              JSR   SENDSTEPS                ;Send the step pulses 
0051 1541              *
0052 1541              * NOW THAT a STEP is in progress open and close IRQ
0053 1541 AD 6C 03              lda   irq_state                ;were interrupts disabled?
0054 1544 D0 03                 bne   @40                      ;yep so leave em that way
0055 1546 58                    cli                            ;this should allow 1 interrupt per seek
0056 1547 EA                    nop   
0057 1548 78                    sei                            ;per track during seek/settling time
0058 1549              *
0059 1549              * Wait until any seeking/speed changing/head settling finishes
0060 1549 A9 0B        @40      lda   #readyadr
0061 154B 20 3A 16              jsr   Read_bit                 ;is seek done yet?
0062 154E 90 1C                 bcc   @80                      ;yes
0063 1550                       longi on
0064 1550 C2 10                 rep   #$10
0065 1552 A2 BC 02              ldx   #700                     ;allow at least 80*6+30 =510 Ms
0066 1555 A0 C8 00     @50      ldy   #200
0067 1558 AF EE C0 E1  @60      lda   >L7clr                   ;(09) read ready status again
0068 155C 10 0C                 bpl   @70                      ;(11) It's ready now
0069 155E 88                    dey                            ;(13)
0070 155F D0 F7                 bne   @60                      ;=16 *.350 = 5.6 us * 200 >= 1 ms 
0071 1561 CA                    dex   
0072 1562 F0 02                 beq   @66                      ;Oh boy I timed out after seek???
0073 1564 80 EF                 bra   @50                      ;see if the dumb drive is ready yet.
0074 1566 E2 10        @66      SEP   #$10
0075 1568 80 0D                 BRA   @NVRRDY                  ;something's wrong if seek takes > .7 secs
0076 156A E2 10        @70      SEP   #$10
0077 156C                       longi off
0078 156C              @80      EQU   *
0079 156C              * 
0080 156C              * Update the current cylinder byte and exit error free 
0081 156C AE 86 03              LDX   DRIVE
0082 156F AD 82 03              LDA   CYL
0083 1572 9D 52 03              STA   cur_cyl,X
0084 1575 18                    CLC                            ;RETURN  Good!
0085 1576 60           @SERR    RTS   
0086 1577              *
0087 1577 A9 2F        @NVRRDY  LDA   #drvr_off_line
0088 1579 38                    SEC   
0089 157A 60                    RTS   
0090 157B
0091 157B              **************************************************
0092 157B              *                                                *
0093 157B              *  sendsteps           Steps a number of tracks  * 
0094 157B              *                        assume IWMDIR to drive  *
0095 157B              *                                   and dir set  * 
0096 157B              *                                                *
0097 157B              *   Input:    X <- number of tracks to step      *
0098 157B              *   Destroys: A, Y                               *
0099 157B              *             X cleared                          *
0100 157B              *                                                *
0101 157B              *  (Delays after stepping until /READY is valid) *
0102 157B              *                                                *
0103 157B              **************************************************
0104 157B              SENDSTEPS EQU   *
0105 157B              *
0106 157B              * Take a step
0107 157B              *
0108 157B A9 04                 LDA   #STEP0ADR
0109 157D 20 47 16              JSR   WRITEBIT
0110 1580              *
0111 1580              * Wait for handshake from drive
0112 1580              *
0113 1580 20 3D 16     @10      JSR   IWM_sense                ; IWM_sense leaves IWM in sense mode
0114 1583 90 FB                 BCC   @10
0115 1585              *
0116 1585              * See if more steps to do
0117 1585              *
0118 1585 CA                    DEX   
0119 1586 D0 F3                 BNE   SENDSTEPS
0120 1588              *
0121 1588              * The current Sony /READY is not valid for 150 microseconds after a
0122 1588              *  step pulse.
0123 1588              *
0124 1588 A2 4F                 LDX   #$4F                     ; constant for 150 usec delay
0125 158A CA           @20      DEX   
0126 158B D0 FD                 BNE   @20
0127 158D 60                    RTS   
0128 158E                       TITLE '     Recalibrate'   
0129 158E              **************************************************
0130 158E              *                                                *
0131 158E              *  recal                       Seek to track 0   *
0132 158E              *                                                *
0133 158E              *   Input:    drive <- current drive             *
0134 158E              *   Output:   cur_cyl <- 0                       *
0135 158E              *             C <- clr:okay, ow step/sensor err  *
0136 158E              *             X <- drive                         *
0137 158E              *   Destroys: A, X, Y                            *
0138 158E              *                                                *
0139 158E              **************************************************
0140 158E              RECAL    EQU   *
0141 158E              *
0142 158E              * Set the step direction to out
0143 158E              *
0144 158E A9 01                 LDA   #DIROUTADR
0145 1590 20 47 16              JSR   WRITEBIT
0146 1593              *
0147 1593 A9 0A                 LDA   #TK0ADR
0148 1595 20 3A 16              JSR   READ_BIT                 ;is is already at trk0?
0149 1598 90 17                 BCC   @30                      ;yes. so alldone
0150 159A              *
0151 159A              * Send a whole bunch of step pulses
0152 159A              *
0153 159A A2 50                 LDX   #RECALTRKS
0154 159C 20 7B 15              JSR   SENDSTEPS
0155 159F              *
0156 159F              * Now wait for /TK0 with timeout
0157 159F              *
0158 159F A2 55                 LDX   #RECALTRKS+5             ;head settling = 5 trk seeks
0159 15A1 A9 07        @10      LDA   #TK0WAIT                 ;Gonna wait a few ms
0160 15A3 20 8F 16              JSR   WAITMS
0161 15A6              *
0162 15A6 A9 0A                 LDA   #TK0ADR
0163 15A8 20 3A 16              JSR   READ_BIT
0164 15AB 90 04                 BCC   @30                      ;=> Saw track 0 
0165 15AD              *
0166 15AD CA                    DEX   
0167 15AE D0 F1                 BNE   @10
0168 15B0              *
0169 15B0              * Never saw /TK0
0170 15B0              @20      EQU   *
0171 15B0 38                    SEC   
0172 15B1              @30      EQU   *
0173 15B1 AE 86 03              LDX   DRIVE
0174 15B4 9E 52 03              STZ   cur_cyl,X
0175 15B7 60                    RTS   
0176 15B8                       TITLE '     Low Level Drive Control Routines'
0177 15B8              **************************************************************
0178 15B8              *
0179 15B8              *  Enable & Sense drive status
0180 15B8              * 
0181 15B8              *   Input:    drive <- current drive
0182 15B8              *   Output:   drv_sts <- b7,b6,b5
0183 15B8              *             C <- clr:okay NO dsw or Offline
0184 15B8              *             C <- set:either dsw or Offline (or both)
0185 15B8              *             X <- drive 
0186 15B8              *   Destroys: A, X, Y
0187 15B8              *
0188 15B8              **************************************************************
0189 15B8                       longa off
0190 15B8                       longi off
0191 15B8                       export enable_sense
0192 15B8              Enable_Sense  
0193 15B8 AE 86 03              ldx   drive
0194 15BB BD 54 03              lda   drv_sts,x
0195 15BE 8D 6A 03              sta   prior_sts                ;save it for offline-online check
0196 15C1 BF EA C0 E1           lda   >enable1,x
0197 15C5 AF E9 C0 E1           lda   select                   ;activate drive enable1/2
0198 15C9 9E 54 03              stz   drv_sts,x                ;clear prior bits
0199 15CC A0 03                 ldy   #03
0200 15CE B9 ED 15     @10      lda   sensbit-1,y
0201 15D1 20 3A 16              jsr   read_bit
0202 15D4 90 09                 bcc   @20                      ;status is low
0203 15D6 B9 F0 15              lda   statbit-1,y              ;status is high so set
0204 15D9 1D 54 03              ora   drv_sts,x                ;this bit 
0205 15DC 9D 54 03              sta   drv_sts,x
0206 15DF 88           @20      dey   
0207 15E0 D0 EC                 bne   @10
0208 15E2 A9 20                 lda   #$20
0209 15E4 3C 54 03              bit   drv_sts,x
0210 15E7 38                    sec   
0211 15E8 30 03                 bmi   @30                      ;dsw is true!
0212 15EA 70 01                 bvs   @30                      ;offline is true
0213 15EC 18                    clc                            ;no error status sensed
0214 15ED 60           @30      rts   
0215 15EE
0216 15EE 08 02 0C     sensbit  DC B:mtronadr,dipadr,ejctadr
0217 15F1 20 40 80     statbit  DC B:$20,$40,$80
0218 15F4
0219 15F4                       eject 
0220 15F4              *****************************************************************
0221 15F4              * 
0222 15F4              *  WaitRdyTO   Waits for /READY for 1.5 seconds
0223 15F4              * 
0224 15F4              *****************************************************************
0225 15F4                       export wait_rdy_to
0226 15F4              WAIT_RDY_TO  
0227 15F4              *
0228 15F4              * Set up to read the /READY line
0229 15F4              *
0230 15F4 A9 0B                 LDA   #READYADR
0231 15F6 20 3A 16              JSR   READ_BIT                 ;Set the control lines
0232 15F9 B0 02                 BCS   @10                      ;its not ready on 1st try
0233 15FB 18           @RDY     CLC   
0234 15FC 60                    RTS   
0235 15FD              * Now Poll for /Ready for 1.5 seconds max
0236 15FD A2 05        @10      LDX   #>1500
0237 15FF A0 DC                 LDY   #<1500
0238 1601 A9 01        @20      LDA   #01
0239 1603 20 8F 16              JSR                            ;waste a 1 ms
0240 1606 AF EE C0 E1           LDA   >L7clr                   ;and test again
0241 160A 10 EF                 BPL   @RDY
0242 160C 88                    DEY   
0243 160D D0 F2                 BNE   @20
0244 160F CA                    DEX   
0245 1610 D0 EF                 BNE   @20
0246 1612 38                    SEC   
0247 1613 60                    RTS   
0248 1614              ***********************************************************
0249 1614              *
0250 1614              * MotorOn
0251 1614              *
0252 1614              ***********************************************************
0253 1614                       export motoron
0254 1614              MOTORON   
0255 1614              *
0256 1614              * First check if the motor is on already
0257 1614 A9 08                 LDA   #MTRONADR
0258 1616 20 3A 16              JSR   READ_BIT
0259 1619 90 0C                 BCC   @90                      	;Yeah no waiting
0260 161B              *
0261 161B              * It wasn't.  Turn it on now.  Control lines are already set.
0262 161B 20 4A 16              JSR   PULSELSTB
0263 161E AF EC C0 E1           lda   >L6CLR                   	;back to rd mode
0264 1622              *
0265 1622              * Have to wait 100 milliseconds before proceeding
0266 1622 A9 32                 LDA   #STDMUPWAIT              ;100
0267 1624 20 8A 16              JSR   WAIT2MS                  ;Wait some time
0268 1627 60           @90      RTS   
0269 1628              ***************************************************
0270 1628              *
0271 1628              * SetHead
0272 1628              ***************************************************
0273 1628                       export sethead
0274 1628              SETHEAD   
0275 1628 AF 31 C0 E1           LDA   >DISKREG                 ; get disk/hdsel register
0276 162C 29 7F                 AND   #$7F                     ; mask off head select bit
0277 162E 2C 7C 03              BIT   SIDE                     ; check which side
0278 1631 10 02                 BPL   @10                      ; set head 0
0279 1633 09 80                 ORA   #$80                     ; else set head 1
0280 1635 8F 31 C0 E1  @10      STA   >DISKREG                 ; set it
0281 1639 60                    RTS   
0282 163A                       eject 
0283 163A              **************************************************
0284 163A              *                                                *
0285 163A              *  ReadBit                Control routines for   *
0286 163A              *  WriteBit       reading/writing signals from   *
0287 163A              *                               the SONY drive   *
0288 163A              *                                                *
0289 163A              *                                                *
0290 163A              *   Input:    A <-  X X X X CA1 CA0 SEL CA2      *
0291 163A              *   Regs:     A cleared (ReadBit: IWM status)    *
0292 163A              *             X preserved                        *
0293 163A              *             Y destroyed                        *
0294 163A              *             c = sense bit 1=high  0 = low      *
0295 163A              **************************************************
0296 163A                       export read_bit
0297 163A              read_bit  
0298 163A              *
0299 163A              * Set up the iwm phase 'control' lines
0300 163A              *
0301 163A 20 53 16              jsr   SDCLINES
0302 163D              *
0303 163D              * Now read the sense line from the IWM into the C flag
0304 163D              * AND leave the IWM in the status sense mode
0305 163D              *
0306 163D CF ED C0 E1  IWM_sense cmp   >L6SET                  ;Set L6 
0307 1641 AF EE C0 E1           LDA   >L7CLR                   ;Read the status
0308 1645 2A                    rol   a                        ;put bit in carry
0309 1646 60                    rts   
0310 1647              *
0311 1647              ********************************************************
0312 1647              *   WriteBit
0313 1647              *
0314 1647              **********************************************************
0315 1647                       export WriteBit
0316 1647              WRITEBIT  
0317 1647              *
0318 1647              * Set up the lines, then 'LSTRB' Acc's lsb over
0319 1647              *
0320 1647 20 53 16              JSR   SDCLINES
0321 164A              *
0322 164A CF E7 C0 E1  PULSELSTB cmp   >LSTRBSET               ;Raise LSTRB
0323 164E CF E6 C0 E1           cmp   >LSTRBCLR                ;Lower it after 2 micros (twice spec)
0324 1652 60                    RTS   
0325 1653                       eject 
0326 1653              ***********************************************************
0327 1653              *
0328 1653              * SDCLINES
0329 1653              ***********************************************************
0330 1653              SDCLINES  
0331 1653              *
0332 1653              * Must set CA0, CA1 before changing HDSEL 1->0
0333 1653              *
0334 1653 CF E0 C0 E1           cmp   >CA0CLR                  ;use CMP long to tag IWM controls
0335 1657 CF E3 C0 E1           cmp   >CA1SET                  ;without disturbing the A reg
0336 165B CF E6 C0 E1           cmp   >LSTRBCLR                ;
0337 165F              *
0338 165F              * Set CA2 per Acc lsb
0339 165F              *
0340 165F CF E4 C0 E1           cmp   >CA2CLR                  ;Assume lsb clear
0341 1663 4A                    LSR   A                        ;lsb -> C ; Acc has 0XXXX CA1 CA0 SEL
0342 1664 90 04                 BCC   @10                      ;=> We were right
0343 1666 CF E5 C0 E1           cmp   >CA2SET                  ;We were wrong, set CA2
0344 166A              *
0345 166A              * Deal with SEL setting
0346 166A              *
0347 166A              @10      EQU   *
0348 166A 4A                    LSR   A                        ;SEL -> C ; Acc has 00XXXX CA1 CA0
0349 166B EB                    xba                            ;HOLD    that thought
0350 166C AF 31 C0 E1           LDA   >DISKREG                 ;Assume SEL will be 0
0351 1670 29 7F                 AND   #$7F                     ; => I'm just psychic
0352 1672 90 02                 BCC   @20                      ; Luckily HDSEL is lsb
0353 1674 09 80                 ORA   #$80                     ; set Hdsel to a one
0354 1676 8F 31 C0 E1  @20      STA   >DISKREG                 ; Finally set SEL correctly
0355 167A EB                    xba                            ;GET     CA0 & CA1 back
0356 167B              *
0357 167B              * Now for CA0, CA1. CA0 is low, CA1 is high,
0358 167B              *  clear them if we were asked to.
0359 167B              *
0360 167B 4A                    LSR   A                        ;C has CA0
0361 167C 90 04                 BCC   @30                      ;If 0, nothing to be done
0362 167E CF E1 C0 E1           cmp   >CA0SET                  ;Okay, set it
0363 1682              *
0364 1682 4A           @30      LSR   A                        ;Get the CA1
0365 1683 B0 04                 BCS   @40
0366 1685 CF E2 C0 E1           cmp   >CA1CLR                  ;Clear it
0367 1689              *
0368 1689 60           @40      RTS   
0369 168A
0370 168A                       TITLE '     Time Delay Subroutines'          
0371 168A              **************************************************
0372 168A              *                                                *
0373 168A              *  waitms        Wait the specified # millisecs  * 
0374 168A              *                         assuming a 2MHZ clock  *
0375 168A              *                   (accurate to roughly +0.7%)  * 
0376 168A              *                                                *
0377 168A              *  If code straddles pages, it is less accurate  *
0378 168A              *                                                *
0379 168A              *   Input:    A <- milliseconds of delay         *
0380 168A              *   Destroys: A ; msdelayctr                     *
0381 168A              *   Prserves: X, Y                               *
0382 168A              *                                                *
0383 168A              **************************************************
0384 168A              WAIT2MS  EQU   *
0385 168A 48                    PHA   
0386 168B 20 8F 16              JSR   WAITMS
0387 168E 68                    PLA   
0388 168F              *****************
0389 168F              WAITMS   EQU   *                        ;Time = Acc * 1.007 millisecs
0390 168F 8D 7A 03              STA   msdelayctr               ;(4) 
0391 1692 AF 36 C0 00           LDA   >CYAREG                  ; slow down to 1Mhz
0392 1696 48                    PHA                            ;        save old settings
0393 1697 29 7F                 AND   #$7F                     ;
0394 1699 8F 36 C0 00           STA   >CYAREG                  ;
0395 169D
0396 169D A9 66        @10      LDA   #102                     ;(2) loop is 1020 1 Mhz cycles 
0397 169F              *
0398 169F 3A           @20      DEC   A                        ;(2) waita is 10 cycles
0399 16A0 D0 00                 BNE   @30                      ;(3)
0400 16A2 EA           @30      NOP                            ;(2)
0401 16A3 D0 FA                 BNE   @20                      ;(3,2)
0402 16A5              *
0403 16A5 CE 7A 03              DEC   msdelayctr               ;(6)
0404 16A8 D0 F3                 BNE   @10                      ;(3,2)
0405 16AA              *
0406 16AA 68                    PLA                            ;        restore cya register
0407 16AB 8F 36 C0 00           STA   >CYAREG                  ;
0408 16AF 60                    RTS                            ;(6)
0409 16B0
0410 16B0                       title '     Device DSW Status'
0411 16B0              *****************************************************************
0412 16B0              *
0413 16B0              * The following routine issues a status call to a class 2 device
0414 16B0              * to check for disk switched.  Class 2 devices indicate disk
0415 16B0              * switched through bit 0 of the general status byte returned
0416 16B0              * on a device status call.
0417 16B0              *
0418 16B0              *
0419 16B0              * ENTRY:        A Reg = Unspecified
0420 16B0              *               X Reg = Unspecified
0421 16B0              *               Y Reg = Unspecified
0422 16B0              *               B Reg = Unspecified
0423 16B0              *             Dir Reg = GS/OS Direct Page
0424 16B0              *               P Reg = N V M X D I Z C  E
0425 16B0              *                       x x 0 0 0 x x x  0
0426 16B0              *
0427 16B0              * EXIT:         A Reg = Condition code
0428 16B0              *               X Reg = Unchanged
0429 16B0              *               Y Reg = Unchanged
0430 16B0              *               B Reg = Unchanged
0431 16B0              *             Dir Reg = GS/OS Direct Page
0432 16B0              *               P Reg = N V M X D I Z C  E
0433 16B0              *                       x x 0 0 0 x x 0  0 if no error
0434 16B0              *                       x x 0 0 0 x x 1  0 if error
0435 16B0              *
0436 16B0              *****************************************************************
0437 16B0                       export c2_dev_stat
0438 16B0              c2_dev_stat  
0439 16B0                       longa on
0440 16B0                       longi on
0441 16B0
0442 16B0 DA                    phx   
0443 16B1 5A                    phy   
0444 16B2
0445 16B2 2C 68 03              bit   ext_slot
0446 16B5 30 2B                 bmi   @notInternal
0447 16B7
0448 16B7 E2 30                 sep   #$30                     ; 8 bit 'm' & 'x'
0449 16B9                       longa off
0450 16B9                       longi off
0451 16B9
0452 16B9 20 25 17              jsr   Enable_Slot6             ;save environ & enable the Internal IWM 
0453 16BC              ;
0454 16BC 20 A7 17              jsr   phases_off               ; all IWM phase lines off
0455 16BF              *
0456 16BF              * REVISION: Driver does its own disk switch sensing and activates the 3.5 drive 
0457 16BF              *           timer (unlike SmartPort status which cancels the 3.5 drive timer)
0458 16BF              *           thus leaving the drive light on and motor running iff a media read
0459 16BF              *           has preceeded this status sense done for a cached read!
0460 16BF              *
0461 16BF              * NOTE:  It is not necessary to change the IWM mode register to do a Status Sense!
0462 16BF              *        A 3.5 drive status sense can be done with the IWM in either 5.25 or 3.5 mode
0463 16BF              *        A 3.5 drive status sense can ALSO be done the the IWM timer running!
0464 16BF              *
0465 16BF              *        if the IWM timer is NOT running the timer must be disabled before the
0466 16BF              *        drive enable is DE-activated to prevent the IWM timer from starting!
0467 16BF              *
0468 16BF A0 04                 ldy   #%00000100
0469 16C1 20 6D 17              jsr   Iff_set_mode             ;prevent IWM timer activation iff its now off
0470 16C4
0471 16C4 20 04 17              jsr   read_dsw_status          ; read disk switched status 
0472 16C7 08                    php   
0473 16C8 A0 00                 ldy   #$00
0474 16CA 20 6D 17              jsr   Iff_set_mode             ;reset IWM mode if Iff its off
0475 16CD 20 A7 17              jsr   phases_off
0476 16D0 20 56 17              jsr   Restore_Slot6            ;reset slotromsel etc
0477 16D3 28                    plp   
0478 16D4
0479 16D4 C2 30                 rep   #$30                     ; 16 bit 'm' & 'x'
0480 16D6                       longa on
0481 16D6                       longi on
0482 16D6
0483 16D6 A2 00 00     @25      ldx   #no_error                ; assume no disk switched error
0484 16D9 90 03                 bcc   @30                      ; if assumed correct
0485 16DB
0486 16DB A2 2E 01              ldx   #drvr_disk_sw+$100       ; else set disk switched error
0487 16DE 8A           @30      txa                            ; restore error code
0488 16DF 7A                    ply   
0489 16E0 FA                    plx   
0490 16E1 60                    rts   
0491 16E2              **********************************************************************
0492 16E2              *
0493 16E2              *	External Slot Device Status Sense 
0494 16E2              *	How the hell do I do this Without disturbing drive?
0495 16E2              *
0496 16E2              **********************************************************************
0497 16E2              @notInternal  
0498 16E2 A0 30 00              ldy   #unit_num
0499 16E5 B7 20                 lda   [drvr_dib_ptr],y
0500 16E7
0501 16E7 E2 20                 sep   #$20
0502 16E9                       longa off
0503 16E9 09 80                 ora   #$80
0504 16EB 8D DC 04              sta   dsw_unit                 ;phantom unit number for dsw sense
0505 16EE C2 20                 rep   #$20
0506 16F0                       longa on
0507 16F0
0508 16F0 A5 00                 lda   <drvr_dev_num
0509 16F2 A2 D6 04              ldx   #dsw_stat                ;make a seemingly invalid status call
0510 16F5 22 80 FC 01           jsl   to_b0_core               ;just doit bozo
0511 16F9
0512 16F9 AD E2 04              lda   dsw_slist
0513 16FC 29 01 00              and   #$0001
0514 16FF C9 01 00              cmp   #$0001
0515 1702 80 D2                 bra   @25
0516 1704
0517 1704              *****************************************************************
0518 1704              *
0519 1704              * The following routine accesses one of two AppleDisk3.5 drives to
0520 1704              * determine if the media has been switched.
0521 1704              *
0522 1704              * ENTRY:        A Reg = Unspecified
0523 1704              *               X Reg = Unspecified
0524 1704              *               Y Reg = unspecified
0525 1704              *               B Reg = Unspecified
0526 1704              *               D Reg = GS/OS Direct Page
0527 1704              *               P Reg = N V M X D I Z C  E
0528 1704              *                       x x 1 1 0 x x x  0
0529 1704              *               Drive = (0/1) setup from dib_hw_unit
0530 1704              * ASSUMES:      IWM is switched
0531 1704              *
0532 1704              * EXIT:         A Reg = Unspecified
0533 1704              *               X Reg = Unspecified
0534 1704              *               Y Reg = Unspecified
0535 1704              *               B Reg = Unspecified
0536 1704              *               D Reg = GS/OS Direct Page
0537 1704              *               P Reg = N V M X D I Z C  E
0538 1704              *                       x x 1 1 0 x x 0  0   No disk switch occured
0539 1704              *                       x x 1 1 0 x x 1  0   Disk switch occured
0540 1704              *
0541 1704              *****************************************************************
0542 1704                       export read_dsw_status
0543 1704              read_dsw_status                         ;
0544 1704                       longa off
0545 1704                       longi off
0546 1704
0547 1704 AE 86 03              ldx   drive
0548 1707 BF EA C0 E1           lda   >enable1,x               ; select desired drive
0549 170B AF E9 C0 E1           lda   >select                  ; Activate the drive interface
0550 170F A9 0C                 lda   #ejctadr
0551 1711 20 3A 16              jsr   read_bit                 ; was device ejected? (preserves X)
0552 1714 AF EC C0 E1           lda   >L6clr                   ;   (restore IWM to read mode)
0553 1718 90 06                 bcc   @10                      ; no
0554 171A A9 03                 lda   #ejct_reset
0555 171C 20 47 16              jsr   writebit
0556 171F 38                    sec   
0557 1720 AF E8 C0 E1  @10      lda   >deselect                ;DeActivate, Thus starting drive's Timer
0558 1724 60                    rts   
0559 1725
0560 1725                       eject 
0561 1725              *****************************************************************
0562 1725              *
0563 1725              * Save Slot 6 environment and enable internal slot 6 IWM
0564 1725              * Setup the Drive work temp from the DIB hw_unit parm
0565 1725              * 
0566 1725              *
0567 1725              * ENTRY:        A Reg = Unspecified
0568 1725              *               X Reg = Unspecified
0569 1725              *               Y Reg = Unspecified
0570 1725              *               B Reg = Unspecified
0571 1725              *               D Reg = GS/OS Direct Page
0572 1725              *               P Reg = N V M X D I Z C  E
0573 1725              *                       x x 1 1 0 x x x  0
0574 1725              *
0575 1725              * EXIT:         A Reg = Unspecified
0576 1725              *               X Reg = unchanged
0577 1725              *               Y Reg = unchanged
0578 1725              *               B Reg = unchanged
0579 1725              *               D Reg = GS/OS Direct Page
0580 1725              *               P Reg = N V M X D I Z C  E
0581 1725              *                       x x 1 1 0 x x x  0 
0582 1725              *
0583 1725              *****************************************************************
0584 1725                       export enable_slot6
0585 1725              enable_slot6                            ;
0586 1725                       longa off
0587 1725                       longi off
0588 1725
0589 1725 A0 52                 ldy   #dib_en_save
0590 1727 AF 36 C0 00           lda   >cyareg
0591 172B 97 20                 sta   [drvr_dib_ptr],Y
0592 172D 29 FB                 and   #%11111011               ;disable slot 6 motor on detector
0593 172F 8F 36 C0 00           sta   >cyareg
0594 1733              ;
0595 1733 AF 2D C0 00           lda   >sltromsel
0596 1737 C8                    iny   
0597 1738 97 20                 sta   [drvr_dib_ptr],Y
0598 173A 29 BF                 and   #%10111111               ;enable internal IWM in slot 6
0599 173C 8F 2D C0 00           sta   >sltromsel
0600 1740              ;
0601 1740 AF 31 C0 E1           lda   >diskreg
0602 1744 C8                    iny   
0603 1745 97 20                 sta   [drvr_dib_ptr],Y
0604 1747 09 40                 ora   #%01000000
0605 1749 8F 31 C0 E1           sta   >diskreg
0606 174D              ;
0607 174D A0 4A                 ldy   #dib_hw_unit
0608 174F B7 20                 lda   [drvr_dib_ptr],Y
0609 1751 3A                    dec   a
0610 1752 8D 86 03              sta   drive                    ;set 0 or 1 into work variable
0611 1755              ;
0612 1755 60                    rts   
0613 1756                       eject 
0614 1756              *****************************************************************
0615 1756              *
0616 1756              * Restore Slot 6 environment to the saved values in DIB
0617 1756              * 
0618 1756              *
0619 1756              * ENTRY:        A Reg = Unspecified
0620 1756              *               X Reg = Unspecified
0621 1756              *               Y Reg = Unspecified
0622 1756              *               B Reg = Unspecified
0623 1756              *               D Reg = GS/OS Direct Page
0624 1756              *               P Reg = N V M X D I Z C  E
0625 1756              *                       x x 1 1 0 x x x  0
0626 1756              *
0627 1756              * EXIT:         A Reg = Unspecified
0628 1756              *               X Reg = unchanged
0629 1756              *               Y Reg = 00
0630 1756              *               B Reg = unchanged
0631 1756              *               D Reg = GS/OS Direct Page
0632 1756              *               P Reg = N V M X D I Z C  E
0633 1756              *                       x x 1 1 0 x x x  0 
0634 1756              *
0635 1756              *****************************************************************
0636 1756                       export restore_slot6
0637 1756              restore_slot6                           ;
0638 1756                       longa off
0639 1756                       longi off
0640 1756
0641 1756 A0 54                 ldy   #dib_en_save+2
0642 1758 B7 20                 lda   [drvr_dib_ptr],Y
0643 175A 8F 31 C0 E1           sta   >diskreg
0644 175E              ;
0645 175E 88                    dey   
0646 175F B7 20                 lda   [drvr_dib_ptr],Y
0647 1761 8F 2D C0 00           sta   >sltromsel
0648 1765              ;
0649 1765 88                    dey   
0650 1766 B7 20                 lda   [drvr_dib_ptr],Y
0651 1768 8F 36 C0 00           sta   >cyareg
0652 176C              ;
0653 176C 60                    rts   
0654 176D
0655 176D                       eject 
0656 176D              *****************************************************************
0657 176D              * This routine checks to see if the iwm Timer is off
0658 176D              * If it is then the IWM mode register is set to the Y-reg mode
0659 176D              * Otherwise nothing is done, leaving the timer running
0660 176D              *
0661 176D              * ENTRY:        A Reg = Unspecified
0662 176D              *               X Reg = Unspecified
0663 176D              *               Y Reg = New IWM mode
0664 176D              *               B Reg = Unspecified
0665 176D              *               D Reg = GS/OS Direct Page
0666 176D              *               P Reg = N V M X D I Z C  E
0667 176D              *                       x x 1 1 0 x x x  0
0668 176D              *
0669 176D              * EXIT:         Y Reg = unchanged
0670 176D              *****************************************************************
0671 176D                       export Iff_set_mode
0672 176D                       longa off
0673 176D                       longi off
0674 176D              Iff_set_mode                            ;
0675 176D AF EE C0 E1           lda   >L7clr                   ; besure not in Write mode
0676 1771 AF ED C0 E1           lda   >L6set                   ; enable status sense mode
0677 1775 AF EE C0 E1           lda   >L7clr                   ; read status reg 
0678 1779 29 20                 and   #$20                     ; is the timer running?
0679 177B F0 05                 beq   set_iwm_mode             ; NO. Thus set mode won't hangup
0680 177D CF EC C0 E1  @10      cmp   >L6clr                   ; leave IWM in read mode
0681 1781 60                    rts   
0682 1782
0683 1782              *****************************************************************
0684 1782              * This routine is used to set the IWM mode register.
0685 1782              *
0686 1782              * ENTRY:        A Reg = Unspecified
0687 1782              *               X Reg = Unspecified
0688 1782              *               Y Reg = New IWM mode
0689 1782              *               P Reg = N V M X D I Z C  E
0690 1782              *                       x x 1 1 0 x x x  0
0691 1782              *
0692 1782              * EXIT:         A Reg = Unspecified
0693 1782              *               X Reg = Unspecified
0694 1782              *               Y Reg = Unchanged
0695 1782              *               P Reg = N V M X D I Z C  E
0696 1782              *                       x x 1 1 0 x x x  0
0697 1782              *
0698 1782              *****************************************************************
0699 1782                       export set_iwm_mode
0700 1782                       longa off
0701 1782                       longi off
0702 1782              set_iwm_mode                            ;
0703 1782 AF E8 C0 E1           lda   >deselect                ; motor must be off
0704 1786 AF ED C0 E1           lda   >l6set                   ; set up access to status register
0705 178A AF EE C0 E1  @10      lda   >l7clr                   ; read iwm status reg
0706 178E 29 20                 and   #%00100000               ; is enable OFF?
0707 1790 D0 F8                 bne   @10                      ; wait for access to IWM mode register
0708 1792 80 05                 bra   @30
0709 1794              @20                                     ;
0710 1794 98                    tya                            ; attempt to set new mode
0711 1795 8F EF C0 E1           sta   >L7set
0712 1799              @30                                     ;
0713 1799 98                    tya                            ; need new mode
0714 179A 4F EE C0 E1           eor   >L7clr                   ; does mode need set?
0715 179E 29 1F                 and   #%00011111               ; 5 LSB's are only relevant parameters
0716 17A0 D0 F2                 bne   @20                      ; still need new mode to be set
0717 17A2 AF EC C0 E1           lda   >L6clr                   ; leave IWM in read mode
0718 17A6 60                    rts   
0719 17A7                       eject 
0720 17A7              *****************************************************************
0721 17A7              *
0722 17A7              * This routine turns off all IWM motor phase lines.
0723 17A7              *
0724 17A7              * ENTRY:        A Reg = Unspecified
0725 17A7              *               X Reg = Unspecified
0726 17A7              *               Y Reg = Unspecified
0727 17A7              *               B Reg = Unspecified
0728 17A7              *               D Reg = GS/OS Direct Page
0729 17A7              *               P Reg = N V M X D I Z C  E
0730 17A7              *                       x x 1 1 0 x x x  0
0731 17A7              *
0732 17A7              * EXIT:         A Reg = Unspecified
0733 17A7              *               X Reg = #$0060 = Slot * 16
0734 17A7              *               Y Reg = Unspecified
0735 17A7              *               B Reg = Unspecified
0736 17A7              *               D Reg = GS/OS Direct Page
0737 17A7              *               P Reg = N V M X D I Z C  E
0738 17A7              *                       x x 1 1 0 x x x  0
0739 17A7              *
0740 17A7              *****************************************************************
0741 17A7                       export phases_off
0742 17A7              phases_off                              ;
0743 17A7                       longa off
0744 17A7                       longi off
0745 17A7
0746 17A7 AF E0 C0 E1           lda   >ca0clr                  ; turn off all phases
0747 17AB AF E2 C0 E1           lda   >ca1clr
0748 17AF AF E4 C0 E1           lda   >ca2clr
0749 17B3 AF E6 C0 E1           lda   >lstrbclr
0750 17B7 60                    rts   
0751 17B8              ;-----------------------------------
0752 17B8                       endp 
0753 17B8
0754 17B8                       eject 
0755 17B8              *****************************************************************
0756 17B8              *
0757 17B8              * The following routine copies the contents of a block that
0758 17B8              * resides in the cache to the buffer specified by the driver
0759 17B8              * call.
0760 17B8              *
0761 17B8              * ENTRY:        A Reg = Unspecified
0762 17B8              *               X Reg = Unspecified
0763 17B8              *               Y Reg = Unspecified
0764 17B8              *               B Reg = Unspecified
0765 17B8              *             Dir Reg = GS/OS Direct Page
0766 17B8              *               P Reg = 16 bit 'm' & 'x'
0767 17B8              *
0768 17B8              * EXIT:         A Reg = Unspecified
0769 17B8              *               X Reg = Same as entry
0770 17B8              *               Y Reg = Unspecified
0771 17B8              *               B Reg = Same as entry
0772 17B8              *             Dir Reg = GS/OS Direct Page
0773 17B8              *               P Reg = 16 bit 'm' & 'x'
0774 17B8              *
0775 17B8              *****************************************************************
0776 17B8                       export cache_to_buff
0777 17B8              cache_to_buff proc 
0778 17B8
0779 17B8 D4 1E                 pei   <drvr_cach_ptr+2         ; source buffer
0780 17BA D4 1C                 pei   <drvr_cach_ptr
0781 17BC D4 06                 pei   <drvr_buf_ptr+2          ; destination buffer
0782 17BE D4 04                 pei   <drvr_buf_ptr
0783 17C0 F4 00 00              pea   $0000                    ; transfer count
0784 17C3 D4 14                 pei   <drvr_blk_size
0785 17C5 F4 05 08              pea   move_sinc_dinc           ; src incr & dest incr
0786 17C8 22 70 FC 01           jsl   move_info                ; go do it to it
0787 17CC 6B                    rtl   
0788 17CD
0789 17CD                       eject 
0790 17CD              *****************************************************************
0791 17CD              *
0792 17CD              * The following routine copies the contents of a block that
0793 17CD              * resides in the buffer specified by the driver call to the
0794 17CD              * cache.
0795 17CD              *
0796 17CD              * ENTRY:        A Reg = Unspecified
0797 17CD              *               X Reg = Unspecified
0798 17CD              *               Y Reg = Unspecified
0799 17CD              *               B Reg = Unspecified
0800 17CD              *             Dir Reg = GS/OS Direct Page
0801 17CD              *               P Reg = 16 bit 'm' & 'x'
0802 17CD              *
0803 17CD              * EXIT:         A Reg = Unspecified
0804 17CD              *               X Reg = Same as entry
0805 17CD              *               Y Reg = Unspecified
0806 17CD              *               B Reg = Same as entry
0807 17CD              *             Dir Reg = GS/OS Direct Page
0808 17CD              *               P Reg = 16 bit 'm' & 'x'
0809 17CD              *
0810 17CD              *****************************************************************
0811 17CD                       export buff_to_cache
0812 17CD              buff_to_cache                           ;
0813 17CD D4 06                 pei   <drvr_buf_ptr+2          ; source buffer
0814 17CF D4 04                 pei   <drvr_buf_ptr
0815 17D1 D4 1E                 pei   <drvr_cach_ptr+2         ; destination buffer
0816 17D3 D4 1C                 pei   <drvr_cach_ptr
0817 17D5 F4 00 00              pea   $0000                    ; transfer count
0818 17D8 D4 14                 pei   <drvr_blk_size
0819 17DA F4 05 08              pea   move_sinc_dinc           ; src incr & dest incr
0820 17DD 22 70 FC 01           jsl   move_info                ; go do it to it
0821 17E1 6B                    rtl   
0822 17E2
0823 17E2                       endp 
